<?php $__env->startPush('schema'); ?>
<script type="application/ld+json">
<?php echo App\Helpers\SeoHelper::generateSchema('breadcrumb', [
    'items' => [
        ['@type' => 'ListItem', 'position' => 1, 'name' => 'Home', 'item' => url('/')],
        ['@type' => 'ListItem', 'position' => 2, 'name' => 'Services', 'item' => url('/services')]
    ]
]); ?>

</script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<div class="relative bg-gradient-to-br from-gray-900 via-black to-gray-900 py-20 sm:py-32 overflow-hidden">
    <div class="absolute inset-0 bg-[linear-gradient(to_right,#4f4f4f2e_1px,transparent_1px),linear-gradient(to_bottom,#4f4f4f2e_1px,transparent_1px)] bg-[size:4rem_4rem]" aria-hidden="true"></div>
    
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center max-w-4xl mx-auto">
            <div class="mb-6">
                <span class="inline-block px-4 py-2 bg-red-600 border border-red-500 rounded-full text-white text-xs sm:text-sm font-bold tracking-wide shadow-lg shadow-red-600/50">
                    WHAT WE OFFER
                </span>
            </div>
            <h1 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-black text-white mb-6 leading-tight">
                Our <span class="text-red-600">Services</span>
            </h1>
            <p class="text-lg sm:text-xl text-gray-300 leading-relaxed">Comprehensive digital solutions tailored to transform your business and drive exceptional results</p>
        </div>
    </div>
</div>

<!-- Services Grid -->
<section class="py-16 sm:py-24 bg-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 sm:gap-8">
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slug => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="group relative bg-white border-2 border-gray-200 rounded-2xl p-6 sm:p-8 hover:border-red-600 hover:shadow-2xl hover:shadow-red-600/10 transition-all duration-300 hover:-translate-y-2">
                <!-- Icon Badge -->
                <div class="absolute -top-6 left-8">
                    <div class="w-12 h-12 sm:w-14 sm:h-14 bg-red-600 rounded-xl flex items-center justify-center text-2xl sm:text-3xl shadow-lg shadow-red-600/30 group-hover:scale-110 transition-transform">
                        <?php echo e($service['icon']); ?>

                    </div>
                </div>
                
                <div class="mt-8">
                    <h2 class="text-2xl sm:text-3xl font-bold text-gray-900 mb-4 group-hover:text-red-600 transition-colors"><?php echo e($service['title']); ?></h2>
                    <p class="text-gray-600 mb-6 leading-relaxed"><?php echo e($service['description']); ?></p>
                    
                    <a href="/services/<?php echo e($slug); ?>" class="inline-flex items-center px-6 py-3 bg-red-600 text-white font-bold rounded-full hover:bg-red-700 transition-all hover:shadow-lg hover:shadow-red-600/30 group-hover:scale-105">
                        View Details
                        <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                    </a>
                </div>
                
                <!-- Decorative Element -->
                <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-red-500/5 to-transparent rounded-bl-full" aria-hidden="true"></div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 sm:py-20 bg-gradient-to-br from-gray-900 to-black">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-white mb-6">Ready to Start Your Project?</h2>
        <p class="text-lg sm:text-xl text-gray-300 mb-8 max-w-2xl mx-auto">Let's discuss how we can help transform your business with our professional services</p>
        <a href="#contact" class="inline-flex items-center px-8 sm:px-10 py-4 sm:py-5 bg-red-600 text-white font-bold rounded-full hover:bg-red-700 transition-all hover:shadow-2xl hover:shadow-red-600/50 hover:scale-105 text-base sm:text-lg">
            Get Started Today
            <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path></svg>
        </a>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/redx/redxstudios/agency-website/resources/views/services/index.blade.php ENDPATH**/ ?>