<?php $__env->startPush('schema'); ?>
<script type="application/ld+json">
<?php echo App\Helpers\SeoHelper::generateSchema('organization', [
    'name' => config('app.name'),
    'url' => url('/'),
    'social' => ['https://twitter.com/agency', 'https://linkedin.com/company/agency']
]); ?>

</script>
<script type="application/ld+json">
<?php echo App\Helpers\SeoHelper::generateSchema('webpage', [
    'name' => 'Professional Web Development Agency - Custom Websites & Digital Solutions',
    'description' => $seo['description']
]); ?>

</script>
<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "ProfessionalService",
  "name": "<?php echo e(config('app.name')); ?>",
  "image": "<?php echo e(asset('images/logo.png')); ?>",
  "@id": "<?php echo e(url('/')); ?>",
  "url": "<?php echo e(url('/')); ?>",
  "telephone": "+1-555-0100",
  "priceRange": "$$",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "123 Business Street",
    "addressLocality": "San Francisco",
    "addressRegion": "CA",
    "postalCode": "94102",
    "addressCountry": "US"
  },
  "geo": {
    "@type": "GeoCoordinates",
    "latitude": 37.7749,
    "longitude": -122.4194
  },
  "openingHoursSpecification": {
    "@type": "OpeningHoursSpecification",
    "dayOfWeek": ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday"],
    "opens": "09:00",
    "closes": "18:00"
  },
  "sameAs": [
    "https://twitter.com/agency",
    "https://linkedin.com/company/agency",
    "https://facebook.com/agency"
  ]
}
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<header class="relative min-h-screen bg-gradient-to-br from-gray-900 via-black to-gray-900 overflow-hidden" role="banner">
    <!-- Animated Background Grid -->
    <div class="absolute inset-0 bg-[linear-gradient(to_right,#4f4f4f2e_1px,transparent_1px),linear-gradient(to_bottom,#4f4f4f2e_1px,transparent_1px)] bg-[size:4rem_4rem]" aria-hidden="true"></div>
    
    <!-- Red Accent Lines -->
    <div class="absolute top-0 left-1/4 w-px h-full bg-gradient-to-b from-transparent via-red-600 to-transparent opacity-30" aria-hidden="true"></div>
    <div class="absolute top-0 right-1/4 w-px h-full bg-gradient-to-b from-transparent via-red-600 to-transparent opacity-30" aria-hidden="true"></div>
    
    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center justify-center min-h-screen text-center py-20">
            
            <!-- Badge -->
            <div class="mb-6 sm:mb-8">
                <span class="inline-flex items-center gap-2 px-4 sm:px-5 py-2 sm:py-2.5 bg-red-600 border border-red-500 rounded-full text-white text-xs sm:text-sm font-bold tracking-wide shadow-lg shadow-red-600/50">
                    <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-white opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-white"></span>
                    </span>
                    <span class="hidden sm:inline">WELCOME TO REDX STUDIOS</span>
                    <span class="sm:hidden">REDX STUDIOS</span>
                </span>
            </div>
            
            <!-- Main Heading -->
            <h1 class="text-4xl sm:text-6xl md:text-7xl lg:text-8xl xl:text-9xl font-black mb-6 sm:mb-8 text-white leading-none tracking-tight px-4">
                <span class="block">Build The</span>
                <span class="block mt-2 text-red-600">Future</span>
                <span class="block mt-2">Of Your Business</span>
            </h1>
            
            <!-- Subheading -->
            <p class="text-base sm:text-lg md:text-xl lg:text-2xl mb-8 sm:mb-12 text-gray-300 max-w-3xl leading-relaxed px-4">
                We craft <span class="text-red-500 font-bold">exceptional digital experiences</span> that transform ideas into powerful web solutions.
            </p>
            
            <!-- CTA Buttons -->
            <nav class="flex flex-col sm:flex-row gap-4 sm:gap-6 justify-center px-4 mb-12 sm:mb-20 w-full sm:w-auto" aria-label="Primary actions">
                <a href="/services" class="group relative inline-flex items-center justify-center px-8 sm:px-10 py-4 sm:py-5 text-base sm:text-lg font-bold text-white bg-red-600 rounded-full overflow-hidden shadow-2xl shadow-red-600/50 transition-all duration-300 hover:bg-red-700 hover:shadow-red-600/70 hover:scale-105" aria-label="Explore our web development services">
                    <span class="relative z-10">Explore Services</span>
                    <svg class="w-5 h-5 ml-2 relative z-10 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path></svg>
                </a>
                <a href="#contact" class="group relative inline-flex items-center justify-center px-8 sm:px-10 py-4 sm:py-5 text-base sm:text-lg font-bold text-white bg-gray-800 border-2 border-gray-700 rounded-full overflow-hidden transition-all duration-300 hover:bg-white hover:text-gray-900 hover:border-white hover:scale-105" aria-label="Contact us to get started">
                    <span class="relative z-10">Get Started</span>
                    <svg class="w-5 h-5 ml-2 relative z-10 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                </a>
            </nav>
            
            <!-- Stats -->
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6 sm:gap-8 md:gap-12 lg:gap-16 px-4">
                <div>
                    <div class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-red-600 mb-2 sm:mb-3">500+</div>
                    <div class="text-gray-400 text-xs sm:text-sm font-bold uppercase tracking-wider">Projects</div>
                </div>
                <div>
                    <div class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-red-600 mb-2 sm:mb-3">98%</div>
                    <div class="text-gray-400 text-xs sm:text-sm font-bold uppercase tracking-wider">Satisfaction</div>
                </div>
                <div>
                    <div class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-red-600 mb-2 sm:mb-3">50+</div>
                    <div class="text-gray-400 text-xs sm:text-sm font-bold uppercase tracking-wider">Team Members</div>
                </div>
                <div>
                    <div class="text-3xl sm:text-4xl md:text-5xl lg:text-6xl font-black text-red-600 mb-2 sm:mb-3">24/7</div>
                    <div class="text-gray-400 text-xs sm:text-sm font-bold uppercase tracking-wider">Support</div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Scroll Indicator -->
    <div class="absolute bottom-8 left-1/2 -translate-x-1/2 animate-bounce">
        <svg class="w-6 h-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 14l-7 7m0 0l-7-7m7 7V3"></path></svg>
    </div>
</header>

<section class="py-24 bg-white" aria-labelledby="services-heading">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="text-red-600 font-semibold text-sm uppercase tracking-wide">What We Offer</span>
            <h2 id="services-heading" class="text-4xl md:text-6xl font-bold text-gray-900 mt-2 mb-6">Our Web Development Services</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">Comprehensive digital solutions tailored to your business needs. From responsive web design to mobile app development and SEO optimization.</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="group relative bg-white border border-gray-200 rounded-2xl p-8 hover:border-red-600 hover:shadow-2xl hover:shadow-red-600/10 transition-all duration-300 hover:-translate-y-2">
                <div class="absolute top-0 right-0 w-32 h-32 bg-gradient-to-br from-red-500/5 to-transparent rounded-bl-full" aria-hidden="true"></div>
                <div class="relative">
                    <div class="text-5xl mb-6 group-hover:scale-110 transition-transform" aria-hidden="true"><?php echo e($service['icon']); ?></div>
                    <h3 class="text-2xl font-bold text-gray-900 mb-4 group-hover:text-red-600 transition-colors"><?php echo e($service['title']); ?></h3>
                    <p class="text-gray-600 mb-6 leading-relaxed"><?php echo e($service['description']); ?></p>
                    <a href="/services" class="inline-flex items-center px-6 py-3 bg-red-600 text-white font-semibold rounded-full hover:bg-red-700 transition-all hover:shadow-lg hover:shadow-red-600/30 group" aria-label="Learn more about <?php echo e($service['title']); ?>">
                        Learn More
                        <svg class="w-4 h-4 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path></svg>
                    </a>
                </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>

<section class="py-24 bg-gray-50" aria-labelledby="benefits-heading">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="text-red-600 font-semibold text-sm uppercase tracking-wide">Why Choose Us</span>
            <h2 id="benefits-heading" class="text-4xl md:text-6xl font-bold text-gray-900 mt-2 mb-6">Why Choose Our Web Development Agency</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">We deliver exceptional results through expertise, dedication, and proven methodologies that ensure your project success.</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <article class="bg-white rounded-2xl p-8 text-center hover:shadow-xl transition-shadow border border-gray-100">
                <div class="w-16 h-16 bg-red-100 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path></svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-4">Fast Delivery & Agile Development</h3>
                <p class="text-gray-600 leading-relaxed">Quick turnaround times without compromising quality. We use agile methodologies to deliver your project on time and within budget.</p>
            </article>
            
            <article class="bg-white rounded-2xl p-8 text-center hover:shadow-xl transition-shadow border border-gray-100">
                <div class="w-16 h-16 bg-red-100 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path></svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-4">Result Driven Solutions</h3>
                <p class="text-gray-600 leading-relaxed">Focused on achieving your business goals with data-driven strategies and measurable outcomes that increase ROI and conversions.</p>
            </article>
            
            <article class="bg-white rounded-2xl p-8 text-center hover:shadow-xl transition-shadow border border-gray-100">
                <div class="w-16 h-16 bg-red-100 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"></path></svg>
                </div>
                <h3 class="text-2xl font-bold text-gray-900 mb-4">Premium Quality Code</h3>
                <p class="text-gray-600 leading-relaxed">Excellence in every pixel and line of code. Clean, maintainable, and scalable solutions built with industry best practices.</p>
            </article>
        </div>
    </div>
</section>

<section class="py-24 bg-white" aria-labelledby="technologies-heading">
    <div class="container mx-auto px-4">
        <div class="text-center mb-16">
            <span class="text-red-600 font-semibold text-sm uppercase tracking-wide">Our Expertise</span>
            <h2 id="technologies-heading" class="text-4xl md:text-6xl font-bold text-gray-900 mt-2 mb-6">Technologies We Master</h2>
            <p class="text-xl text-gray-600 max-w-3xl mx-auto">Expert in modern web technologies including Laravel, React, Vue.js, Node.js, Tailwind CSS, and more.</p>
        </div>
        
        <div class="flex flex-wrap justify-center gap-4">
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">Laravel</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">React</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">Vue.js</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">Node.js</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">Tailwind CSS</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">PHP</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">JavaScript</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">MySQL</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">MongoDB</span>
            <span class="px-6 py-3 bg-gradient-to-r from-red-50 to-red-100 text-red-700 rounded-full font-semibold border border-red-200 hover:shadow-lg hover:scale-105 transition-all">AWS</span>
        </div>
    </div>
</section>

<section id="contact" class="py-24 bg-gradient-to-br from-gray-900 to-black relative overflow-hidden" aria-labelledby="contact-heading">
    <div class="absolute inset-0 bg-[radial-gradient(circle_at_50%_50%,rgba(220,38,38,0.1),transparent_70%)]" aria-hidden="true"></div>
    
    <div class="container mx-auto px-4 max-w-4xl relative z-10">
        <div class="text-center mb-12">
            <span class="text-red-500 font-semibold text-sm uppercase tracking-wide">Let's Talk</span>
            <h2 id="contact-heading" class="text-4xl md:text-6xl font-bold text-white mt-2 mb-6">Get In Touch - Free Consultation</h2>
            <p class="text-xl text-gray-300">Ready to start your project? Contact our web development team today for a free consultation and quote.</p>
        </div>
        
        <div class="bg-white rounded-3xl shadow-2xl p-8 md:p-12">
            <form class="space-y-6" action="#" method="POST" aria-label="Contact form">
                <div class="grid md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2" for="name">Full Name *</label>
                        <input type="text" id="name" name="name" placeholder="John Doe" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-red-600 focus:border-transparent transition-all" required aria-required="true">
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2" for="email">Email Address *</label>
                        <input type="email" id="email" name="email" placeholder="john@example.com" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-red-600 focus:border-transparent transition-all" required aria-required="true">
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2" for="message">Project Details *</label>
                    <textarea id="message" name="message" rows="6" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-red-600 focus:border-transparent transition-all" placeholder="Tell us about your project requirements..." required aria-required="true"></textarea>
                </div>
                
                <button type="submit" class="group w-full bg-red-600 text-white font-bold py-5 px-8 rounded-full hover:bg-red-700 transition-all hover:shadow-2xl hover:shadow-red-600/50 hover:scale-[1.02]">
                    <span class="flex items-center justify-center">
                        Send Message
                        <svg class="w-5 h-5 ml-2 group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3"></path></svg>
                    </span>
                </button>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/redx/redxstudios/agency-website/resources/views/home.blade.php ENDPATH**/ ?>