@extends('layouts.app')

@push('schema')
<script type="application/ld+json">
{!! App\Helpers\SeoHelper::generateSchema('service', [
    'serviceType' => $service['title'],
    'description' => $service['description']
]) !!}
</script>
<script type="application/ld+json">
{!! App\Helpers\SeoHelper::generateSchema('breadcrumb', [
    'items' => [
        ['@type' => 'ListItem', 'position' => 1, 'name' => 'Home', 'item' => url('/')],
        ['@type' => 'ListItem', 'position' => 2, 'name' => 'Services', 'item' => url('/services')],
        ['@type' => 'ListItem', 'position' => 3, 'name' => $service['title'], 'item' => url('/services/' . $slug)]
    ]
]) !!}
</script>
@endpush

@section('content')
<!-- Hero Section -->
<div class="relative bg-gradient-to-br from-gray-900 via-black to-gray-900 py-20 sm:py-32 overflow-hidden">
    <div class="absolute inset-0 bg-[linear-gradient(to_right,#4f4f4f2e_1px,transparent_1px),linear-gradient(to_bottom,#4f4f4f2e_1px,transparent_1px)] bg-[size:4rem_4rem]" aria-hidden="true"></div>
    
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
        <div class="text-center max-w-4xl mx-auto">
            <div class="text-6xl sm:text-7xl md:text-8xl mb-8">{{ $service['icon'] }}</div>
            <h1 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-black text-white mb-6 leading-tight">
                {{ $service['title'] }}
            </h1>
            <p class="text-lg sm:text-xl text-gray-300 leading-relaxed">{{ $service['description'] }}</p>
        </div>
    </div>
</div>

<!-- Breadcrumb -->
<div class="bg-gray-50 border-b border-gray-200">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-4">
        <nav class="flex text-sm text-gray-600" aria-label="Breadcrumb">
            <a href="/" class="hover:text-red-600 transition-colors">Home</a>
            <span class="mx-2">/</span>
            <a href="/services" class="hover:text-red-600 transition-colors">Services</a>
            <span class="mx-2">/</span>
            <span class="text-gray-900 font-semibold">{{ $service['title'] }}</span>
        </nav>
    </div>
</div>

<!-- Features Section -->
<section class="py-16 sm:py-24 bg-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 max-w-6xl">
        <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-gray-900 mb-4 text-center">What We Offer</h2>
        <p class="text-center text-gray-600 mb-12 sm:mb-16 max-w-2xl mx-auto">Comprehensive solutions designed to meet your specific needs and exceed expectations</p>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
            @foreach($service['features'] as $feature)
            <div class="flex items-start gap-4 p-6 bg-gray-50 rounded-xl border border-gray-200 hover:border-red-600 hover:shadow-lg transition-all group">
                <div class="flex-shrink-0 w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>
                </div>
                <span class="text-lg font-semibold text-gray-900 mt-1">{{ $feature }}</span>
            </div>
            @endforeach
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 sm:py-20 bg-gradient-to-br from-gray-900 to-black">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 max-w-4xl">
        <div class="text-center">
            <h2 class="text-3xl sm:text-4xl md:text-5xl font-black text-white mb-6">Ready to Get Started?</h2>
            <p class="text-lg sm:text-xl text-gray-300 mb-8">Let's discuss how we can help transform your business with our {{ $service['title'] }} services.</p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="/#contact" class="inline-flex items-center justify-center px-8 sm:px-10 py-4 sm:py-5 bg-red-600 text-white font-bold rounded-full hover:bg-red-700 transition-all hover:shadow-2xl hover:shadow-red-600/50 hover:scale-105 text-base sm:text-lg">
                    Contact Us
                    <svg class="w-5 h-5 ml-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path></svg>
                </a>
                <a href="/services" class="inline-flex items-center justify-center px-8 sm:px-10 py-4 sm:py-5 bg-gray-800 text-white font-bold rounded-full hover:bg-gray-700 transition-all hover:scale-105 text-base sm:text-lg border-2 border-gray-700">
                    View All Services
                </a>
            </div>
        </div>
    </div>
</section>
@endsection
