<?php

namespace App\Http\Controllers;

class SitemapController extends Controller
{
    public function index()
    {
        $urls = [
            ['loc' => url('/'), 'priority' => '1.0', 'changefreq' => 'daily'],
            ['loc' => url('/services'), 'priority' => '0.9', 'changefreq' => 'weekly'],
            ['loc' => url('/services/web-design'), 'priority' => '0.8', 'changefreq' => 'weekly'],
            ['loc' => url('/services/web-development'), 'priority' => '0.8', 'changefreq' => 'weekly'],
            ['loc' => url('/services/mobile-apps'), 'priority' => '0.8', 'changefreq' => 'weekly'],
            ['loc' => url('/services/seo-optimization'), 'priority' => '0.8', 'changefreq' => 'weekly'],
        ];

        return response()->view('sitemap', compact('urls'))->header('Content-Type', 'text/xml');
    }
}
