<?php

namespace App\Http\Controllers;

use App\Helpers\SeoHelper;

class HomeController extends Controller
{
    public function index()
    {
        $seo = SeoHelper::generateMeta([
            'title' => 'Professional Web Development Agency | Custom Websites & Digital Solutions',
            'description' => 'Leading web development agency specializing in custom websites, mobile apps, SEO optimization, and digital solutions. Transform your business with cutting-edge technology and expert developers.',
            'keywords' => 'web development agency, custom website development, mobile app development, SEO services, UI/UX design, Laravel development, React development, digital agency, web design company, software development',
        ]);

        $services = [
            ['icon' => '🎨', 'title' => 'Web Design', 'description' => 'Beautiful, responsive designs that captivate your audience'],
            ['icon' => '💻', 'title' => 'Web Development', 'description' => 'Custom web applications built with modern technologies'],
            ['icon' => '📱', 'title' => 'Mobile Apps', 'description' => 'Native and cross-platform mobile solutions'],
            ['icon' => '🚀', 'title' => 'SEO Optimization', 'description' => 'Boost your visibility and rank higher on search engines'],
            ['icon' => '☁️', 'title' => 'Cloud Solutions', 'description' => 'Scalable cloud infrastructure and deployment'],
            ['icon' => '🔧', 'title' => 'Maintenance', 'description' => 'Ongoing support and maintenance for your digital assets'],
        ];

        return view('home', compact('seo', 'services'));
    }
}
