<?php

namespace App\Helpers;

class SeoHelper
{
    public static function generateMeta(array $data): array
    {
        return [
            'title' => $data['title'] ?? config('app.name'),
            'description' => $data['description'] ?? 'Professional web development agency',
            'keywords' => $data['keywords'] ?? 'web development, design, SEO',
            'canonical' => $data['canonical'] ?? url()->current(),
            'og_title' => $data['og_title'] ?? $data['title'] ?? config('app.name'),
            'og_description' => $data['og_description'] ?? $data['description'] ?? '',
            'og_image' => $data['og_image'] ?? asset('images/og-default.jpg'),
            'og_url' => $data['og_url'] ?? url()->current(),
            'twitter_card' => $data['twitter_card'] ?? 'summary_large_image',
        ];
    }

    public static function generateSchema(string $type, array $data): string
    {
        $schemas = [
            'organization' => [
                '@context' => 'https://schema.org',
                '@type' => 'Organization',
                'name' => $data['name'] ?? config('app.name'),
                'url' => $data['url'] ?? url('/'),
                'logo' => $data['logo'] ?? asset('images/logo.png'),
                'contactPoint' => [
                    '@type' => 'ContactPoint',
                    'telephone' => $data['phone'] ?? '+1-555-0100',
                    'contactType' => 'customer service',
                ],
                'sameAs' => $data['social'] ?? [],
            ],
            'service' => [
                '@context' => 'https://schema.org',
                '@type' => 'Service',
                'serviceType' => $data['serviceType'] ?? '',
                'provider' => [
                    '@type' => 'Organization',
                    'name' => config('app.name'),
                ],
                'description' => $data['description'] ?? '',
            ],
            'webpage' => [
                '@context' => 'https://schema.org',
                '@type' => 'WebPage',
                'name' => $data['name'] ?? '',
                'description' => $data['description'] ?? '',
                'url' => $data['url'] ?? url()->current(),
            ],
            'breadcrumb' => [
                '@context' => 'https://schema.org',
                '@type' => 'BreadcrumbList',
                'itemListElement' => $data['items'] ?? [],
            ],
        ];

        return json_encode($schemas[$type] ?? [], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    }
}
